/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.bedspreads.common;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraftforge.client.IItemRenderProperties;
import top.theillusivec4.bedspreads.client.renderer.DecoratedBedItemStackRenderer;
import top.theillusivec4.bedspreads.common.DecoratedBedsRegistry;

public class DecoratedBedItem
extends BedItem {
    public DecoratedBedItem() {
        super(DecoratedBedsRegistry.DECORATED_BED_BLOCK, new Item.Properties().m_41487_(1));
    }

    public static ItemStack getBedStack(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41720_() instanceof DecoratedBedItem && (compound = stack.m_41737_("BlockEntityTag")) != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("BedStack"));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getBannerStack(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41720_() instanceof DecoratedBedItem && (compound = stack.m_41737_("BlockEntityTag")) != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("BannerStack"));
        }
        return ItemStack.f_41583_;
    }

    public static DyeColor getBannerColor(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BannerItem) {
            return ((AbstractBannerBlock)((BannerItem)stack.m_41720_()).m_40614_()).m_48674_();
        }
        return DyeColor.WHITE;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        ItemStack bed = DecoratedBedItem.getBedStack(stack);
        ItemStack banner = DecoratedBedItem.getBannerStack(stack);
        if (!bed.m_41619_()) {
            tooltip.add((Component)new TranslatableComponent(bed.m_41778_()).m_130940_(ChatFormatting.GRAY));
        }
        if (!banner.m_41619_()) {
            tooltip.add((Component)new TranslatableComponent(banner.m_41778_()).m_130940_(ChatFormatting.GRAY));
            BannerItem.m_40542_((ItemStack)banner, tooltip);
        }
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                Minecraft mc = Minecraft.m_91087_();
                return new DecoratedBedItemStackRenderer(mc.m_167982_(), mc.m_167973_());
            }
        });
    }
}

